//==============================================================================
// Project:		Wealth Transfers and their Economic Effects
// File name:	Wealth at Death - Actual Deaths
// Objective: 	Calculating the wealth held at death using actual deaths 
//				recorded in HILDA.
//
// Created: 	20/05/2021
// Modified: 	15/11/2021
//==============================================================================

**************************
*** Importing the Data ***
**************************

clear

cd "XXXX"	// set content directory here

use HILDA_restricted_combined_rescaled	// opening the HILDA dataset

xtset xwaveid wave	// declaring the dataset to be a panel

*************************
*** Cleaning the Data ***
*************************

tab yodeath
drop if yodeath == -1	// dropping people from the sample who have not died

drop if year > yodeath
drop if year < yodeath - 4	// dropping observations that are not close to the year of death

keep if (wave == 2 | wave == 6 | wave == 10 | wave == 14)	// keeping only wealth module years

gen net_worth = pwassei - pwdebti	// generating a net worth variable

drop if year < yodeath & F4.net_worth != .	// dropping the old wealth observation for people who had two observations in the sample

drop if yodeath == 2001 | yodeath == 2002	// dropping years 2001 and 2002

replace net_worth = 0 if net_worth < 0	// replacing negative net worth as zero because negative wealth cannot be passed on

********************************
*** Generating Key Variables ***
********************************

gen wt_net_worth = net_worth * benchmarked_new_hhwte	// generating an aggregate wealth variable

destring hhpxid, replace
gen final = 0
replace final = 1 if hhpxid == .	// identifying final deaths

gen sample_deaths = 1								// death indicator
gen deaths = benchmarked_new_hhwte					// calculating the implied number of deaths in the population
gen final_deaths = final * benchmarked_new_hhwte	// calculating the implied number of single-person deaths in the population
gen final_net_worth = final * net_worth				// calculating the value of single-person estates
gen final_wt_net_worth = final * wt_net_worth		// calculating the aggregate value of single-person estates

******************************
*** Collapsing the Dataset ***
******************************

collapse(sum) net_worth wt_net_worth final_net_worth final_wt_net_worth sample_deaths deaths final final_deaths, by(yodeath)	// collapsing the dataset by year

drop if (yodeath != 2003 & yodeath != 2007 & yodeath != 2011 & yodeath != 2015)	// keeping only deaths that occurred the year after a wealth module

rename yodeath year

drop net_worth final_net_worth sample final	// dropping unused variables

gen single_death_percent = final_deaths / deaths	// calculating the porportion of deaths that were single-persons

save Inheritance_outflows_actual_deaths.dta, replace	// saving the dataset